%%% "Modeling changes in US monetary policy using a time-varying nonlinear
%%% Taylor rule"
%%% Nguyen, Pavlidisz, and Peel

% The main code to replicate the figures in the paper

%************************************************************************
clc
clear all
% Load data

data=xlsread('Data_Quaterly_Prepared');


% Estimation

[MEANFILTER,QUANTILE_L,QUANTILE_U,QUANTILE_2L,QUANTILE_2U]=Filterestimate(data);

% --------------------------- OUTPUT ---------------------------------
% MEANFILTER: Estimates of state variables (Filtered)
% QUANTILE_L,QUANTILE_U: 68% quantiles
% QUANTILE_2L,QUANTILE_2U: 90 % quantile


% PLOT 

number_start=11;  % the first 10 is for trial sample, so plotting from 11th obs 
%Set up dates
initial_year=1966;
end_year=2007;
range_year=end_year-initial_year+1;
years=zeros(range_year*4,1);
 
for i=1:range_year
    years(4*(i-1)+1:4*i)=initial_year*ones(1,4)+(i-1)*ones(1,4);
end
years1=years(number_start:(length(years))) ;

months=years;
 
for i=1:range_year
    months(4*(i-1)+1:4*i)=[1 4 7 10]';
end
months1=months(number_start:(length(months)));   
 
p=size(months1,1);

B=[years1 months1 ones(p,1) zeros(p,1) zeros(p,1) zeros(p,1)];

dt=datenum(B);

X=MEANFILTER; A=QUANTILE_L; B=QUANTILE_U; C=QUANTILE_2L; D=QUANTILE_2U;


start=number_start;  
alw=0.2;
unit_line=ones(1,size(MEANFILTER,2));
zeros_line=zeros(1,size(MEANFILTER,2));
figure(5)
i=1;
plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw); hold off
title('Stochastic Volatility')
datetick('x','yyyy','keeplimits')

figure(6)
i=2;
plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw); hold off
title('Smoothing Parameter')
datetick('x','yyyy','keeplimits')


figure(7)
i=3;
plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw); hold off
title('Intercept')
datetick('x','yyyy','keeplimits')



figure(3)

i=4;

plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw);...
    plot(dt,unit_line(start:end),'-','LineWidth',1); hold off
ylim([-2,3])
title('Response to Inflation')
datetick('x','yyyy','keeplimits')

figure(4)
i=5;
plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw);...
    plot(dt,zeros_line(start:end),'-k','LineWidth',alw); hold off
title('Response to Inflation Variance')
datetick('x','yyyy','keeplimits')

figure(2)
i=6;
plot(dt,X(i,start:end),'b','linewidth',1); hold all; plot(dt,A(i,start:end),'--k','linewidth',alw); ...
    plot(dt,B(i,start:end),'--k','linewidth',alw); plot(dt,C(i,start:end),':k','linewidth',alw); plot(dt,D(i,start:end),':k','linewidth',alw);...
    plot(dt,zeros_line(start:end),'-k','LineWidth',alw); hold off
ylim([-1,5])
title('Response to Real Activity')

datetick('x','yyyy','keeplimits')


